/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.select;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.rooms.TreasureRoomBoss;
import com.megacrit.cardcrawl.screens.mainMenu.MenuCancelButton;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import com.megacrit.cardcrawl.vfx.BossChestShineEffect;
import java.util.ArrayList;
import java.util.HashMap;

public class BossRelicSelectScreen {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("BossRelicSelectScreen");
    public static final String[] TEXT = BossRelicSelectScreen.uiStrings.TEXT;
    private boolean isDone = false;
    public ArrayList<AbstractRelic> relics = new ArrayList();
    public MenuCancelButton cancelButton = new MenuCancelButton();
    private static final String SELECT_MSG = TEXT[2];
    private Texture smokeImg;
    private float shineTimer = 0.0f;
    private static final float SHINE_INTERAL = 0.1f;
    private static final float SLOT_1_X = 964.0f * Settings.scale;
    private static final float SLOT_1_Y = 700.0f * Settings.scale;
    private static final float SLOT_2_X = 844.0f * Settings.scale;
    private static final float SLOT_2_Y = 560.0f * Settings.scale;
    private static final float SLOT_3_X = 1084.0f * Settings.scale;
    private static final float SLOT_3_Y = 560.0f * Settings.scale;

    public void update() {
        this.shineTimer -= Gdx.graphics.getDeltaTime();
        if (this.shineTimer < 0.0f) {
            this.shineTimer = 0.1f;
            AbstractDungeon.topLevelEffects.add(new BossChestShineEffect());
            AbstractDungeon.topLevelEffects.add(new BossChestShineEffect(MathUtils.random(0.0f, (float)Settings.WIDTH), MathUtils.random(0.0f, (float)Settings.HEIGHT - 128.0f * Settings.scale)));
        }
        for (AbstractRelic r : this.relics) {
            r.update();
            if (!r.isObtained) continue;
            HashMap<String, Object> choice = new HashMap<String, Object>();
            ArrayList<String> notPicked = new ArrayList<String>();
            choice.put("picked", r.relicId);
            TreasureRoomBoss curRoom = (TreasureRoomBoss)AbstractDungeon.getCurrRoom();
            curRoom.choseRelic = true;
            for (AbstractRelic otherRelics : this.relics) {
                if (otherRelics == r) continue;
                notPicked.add(otherRelics.relicId);
            }
            choice.put("not_picked", notPicked);
            CardCrawlGame.metricData.boss_relics.add(choice);
            this.isDone = true;
            AbstractDungeon.getCurrRoom().rewardPopOutTimer = 99999.0f;
            AbstractDungeon.overlayMenu.proceedButton.hide();
            if (!r.relicId.equals("Black Blood") && !r.relicId.equals("Ring of the Serpent")) continue;
            r.instantObtain(AbstractDungeon.player, 0, false);
            AbstractDungeon.getCurrRoom().rewardPopOutTimer = 0.25f;
        }
        if (this.isDone) {
            this.isDone = false;
            AbstractDungeon.overlayMenu.cancelButton.hide();
            this.relics.clear();
            AbstractDungeon.closeCurrentScreen();
        }
        this.updateCancelButton();
    }

    private void updateCancelButton() {
        this.cancelButton.update();
        if (this.cancelButton.hb.clicked) {
            this.cancelButton.hb.clicked = false;
            if (AbstractDungeon.getCurrRoom() instanceof TreasureRoomBoss && AbstractDungeon.screen == AbstractDungeon.CurrentScreen.BOSS_REWARD) {
                TreasureRoomBoss r = (TreasureRoomBoss)AbstractDungeon.getCurrRoom();
                r.chest.close();
            }
            AbstractDungeon.closeCurrentScreen();
            AbstractDungeon.getCurrRoom().rewardPopOutTimer = 0.25f;
            AbstractDungeon.overlayMenu.proceedButton.hide();
        }
    }

    public void noPick() {
        ArrayList<String> notPicked = new ArrayList<String>();
        HashMap<String, ArrayList<String>> choice = new HashMap<String, ArrayList<String>>();
        for (AbstractRelic otherRelics : this.relics) {
            notPicked.add(otherRelics.relicId);
        }
        choice.put("not_picked", notPicked);
        CardCrawlGame.metricData.boss_relics.add(choice);
    }

    public void render(SpriteBatch sb) {
        for (AbstractGameEffect e : AbstractDungeon.effectList) {
            e.render(sb);
        }
        this.cancelButton.render(sb);
        ((TreasureRoomBoss)AbstractDungeon.getCurrRoom()).chest.render(sb);
        AbstractDungeon.player.render(sb);
        sb.setColor(Color.WHITE);
        sb.draw(this.smokeImg, 470.0f * Settings.scale, AbstractDungeon.floorY - 58.0f * Settings.scale, (float)this.smokeImg.getWidth() * Settings.scale, (float)this.smokeImg.getHeight() * Settings.scale);
        for (AbstractRelic r : this.relics) {
            r.render(sb);
        }
    }

    public void reopen() {
        this.refresh();
        this.cancelButton.show(TEXT[3]);
        AbstractDungeon.dynamicBanner.appearInstantly(800.0f * Settings.scale, SELECT_MSG);
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.BOSS_REWARD;
        AbstractDungeon.overlayMenu.proceedButton.hide();
        AbstractDungeon.overlayMenu.showBlackScreen();
    }

    public void open(ArrayList<AbstractRelic> chosenRelics) {
        this.refresh();
        this.relics.clear();
        this.cancelButton.show(TEXT[3]);
        AbstractDungeon.dynamicBanner.appear(800.0f * Settings.scale, SELECT_MSG);
        this.smokeImg = ImageMaster.loadImage("images/ui/bossRelicScreenOverlay.png");
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.BOSS_REWARD;
        AbstractDungeon.overlayMenu.proceedButton.hide();
        AbstractDungeon.overlayMenu.showBlackScreen();
        AbstractRelic r = chosenRelics.get(0);
        r.spawn(SLOT_1_X, SLOT_1_Y);
        r.hitbox.move(r.currentX, r.currentY);
        this.relics.add(r);
        AbstractRelic r2 = chosenRelics.get(1);
        r2.spawn(SLOT_2_X, SLOT_2_Y);
        r2.hitbox.move(r2.currentX, r2.currentY);
        this.relics.add(r2);
        AbstractRelic r3 = chosenRelics.get(2);
        r3.spawn(SLOT_3_X, SLOT_3_Y);
        r3.hitbox.move(r3.currentX, r3.currentY);
        this.relics.add(r3);
        for (AbstractRelic r1 : this.relics) {
            UnlockTracker.markRelicAsSeen(r1.relicId);
        }
    }

    public void refresh() {
        this.isDone = false;
        this.cancelButton = new MenuCancelButton();
        this.shineTimer = 0.0f;
    }

    public void hide() {
        AbstractDungeon.dynamicBanner.hide();
        AbstractDungeon.overlayMenu.cancelButton.hide();
    }
}

